function OnePageDisplayCtrl($scope, $rootScope, StructureJson, $timeout){
    /**
     * Strony
     *
     * @type {*}
     */
    $scope.pages = StructureJson.getPages();

    $scope.leftPageIndex = StructureJson.getLeftPageIndex();
    $scope.currentPage = ($scope.leftPageIndex) ? $scope.pages[$scope.leftPageIndex] : $scope.pages[0];

    $scope.$on('Page:change', function(e, changeData){
        if(changeData.singleView)
        {
            if(changeData.direction == 1)
            {
                $scope.currentPage = $scope.getNextPage(changeData.currentPage);
            }
            else
            {
                $scope.currentPage = $scope.getPreviousPage(changeData.currentPage);
            }
        }
        else
        {
            if(changeData.direction == 1)
            {
                $scope.currentPage = $scope.getNextPage($scope.getNextPage(changeData.currentPage))
            }
            else
            {
                $scope.currentPage = $scope.getPreviousPage(changeData.currentPage)
                if(!StructureJson.isFirstPage($scope.currentPage))
                {
                    $scope.currentPage = $scope.getPreviousPage();
                }
            }
        }

        $scope.$apply();
    });


    $scope.fitPageInWindow = function(){
        var scale = getScale($rootScope.pageMaxWidth, $rootScope.pageMaxHeight, StructureJson.getPageWidth(), StructureJson.getPageHeight());
        angular.element('.one-page').css('width', scale * StructureJson.getPageWidth()).css('height', scale * StructureJson.getPageHeight());
    }
    $scope.fitPageInWindow();
    $rootScope.$on('Window:resize', function(){
        $scope.fitPageInWindow();
        $scope.$apply();
    });



    $scope.$on('Page:jump', function(e, page){
        $scope.currentPage = page;
        $scope.$apply();
    });



    $scope.isActive = function(page){
        return $scope.currentPage == page;
    }

    $scope.getBackgroundUrl = function(page){
        if(page === false || typeof page == 'undefined')
        {
            return '';
        }
        return dataPath + $scope.currentPage.preview;
    }



    $scope.goToNextPage = function(){
        if(!$scope.isLast())
        {
            $rootScope.$broadcast('Page:beforeChange', {
                direction: 1,
                singleView: 1,
                isLeftPage: StructureJson.isLeftPage($scope.currentPage),
                currentPage: $scope.currentPage
            });
        }
    }

    $scope.goToPreviousPage = function(){
        if(!$scope.isFirst())
        {
//            angular.element('.one-page').fadeOut('slow', function(){
//                $rootScope.$broadcast('Page:change', {
//                    direction: -1,
//                    singleView: 1,
//                    isLeftPage: StructureJson.isLeftPage($scope.currentPage),
//                    currentPage: $scope.currentPage
//                });
//                $scope.$apply();
//                angular.element('.one-page').fadeIn('slow');
//            });

            $rootScope.$broadcast('Page:beforeChange', {
                direction: -1,
                singleView: 1,
                isLeftPage: StructureJson.isLeftPage($scope.currentPage),
                currentPage: $scope.currentPage
            });
        }
    }


    $scope.getNextPage = function(page){
        page = (typeof page != 'undefined') ? page : $scope.currentPage;
        var index = $scope.pages.indexOf(page);
        return (index < $scope.pages.length - 1) ? $scope.pages[++index] : false;
    }


    $scope.getPreviousPage = function(page){
        page = (typeof page != 'undefined') ? page : $scope.currentPage;
        var index = $scope.pages.indexOf(page);
        return (index > 0) ? $scope.pages[--index] : false;
    }


    /**
     * Czy obecna strona jest pierwszą
     * @returns {boolean}
     */
    $scope.isFirst = function(){
        return $scope.pages.indexOf($scope.currentPage) == 0;
    }


    /**
     * Czy obecna strona jest ostatnią
     * @returns {boolean}
     */
    $scope.isLast = function(){
        return $scope.pages.indexOf($scope.currentPage) == $scope.pages.length - 1;
    }
}


OnePageDisplayCtrl.$inject = ['$scope', '$rootScope', 'StructureJson', '$timeout'];